package com.company.deliverytest.entity;

import io.jmix.core.DeletePolicy;
import io.jmix.core.annotation.DeletedBy;
import io.jmix.core.annotation.DeletedDate;
import io.jmix.core.entity.annotation.JmixGeneratedValue;
import io.jmix.core.entity.annotation.OnDelete;
import io.jmix.core.entity.annotation.OnDeleteInverse;
import io.jmix.core.metamodel.annotation.Comment;
import io.jmix.core.metamodel.annotation.JmixEntity;
import jakarta.persistence.*;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.UUID;

@JmixEntity
@Table(name = "DEL_CARRIER", indexes = {
        @Index(name = "IDX_DEL_CARRIER_CURR_ORDER", columnList = "CURR_ORDER_ID")
})
@Entity(name = "del_Carrier")
public class Carrier {
    @JmixGeneratedValue
    @Column(name = "ID", nullable = false)
    @Id
    private UUID id;

    @Comment("имя курьера")
    @Column(name = "CARR_NAME")
    private String carr_name;

    @Comment("пароль курьера")
    @Column(name = "CARR_PASSWORD")
    private String carr_password;

    @Comment("текущий заказ")
    @JoinColumn(name = "CURR_ORDER_ID")
    @OneToOne(fetch = FetchType.LAZY)
    private Order currOrder;

    @Comment("список всех заказов, выполненных курьером")
    @OnDeleteInverse(DeletePolicy.UNLINK)
    @OnDelete(DeletePolicy.UNLINK)
    @OneToMany(mappedBy = "carrier")
    private List<Order> allOrders;

    @DeletedBy
    @Column(name = "DELETED_BY")
    private String deletedBy;

    @DeletedDate
    @Column(name = "DELETED_DATE")
    private OffsetDateTime deletedDate;

    public String getCarr_password() {
        return carr_password;
    }

    public void setCarr_password(String carr_password) {
        this.carr_password = carr_password;
    }

    public String getCarr_name() {
        return carr_name;
    }

    public void setCarr_name(String carr_name) {
        this.carr_name = carr_name;
    }

    public List<Order> getAllOrders() {
        return allOrders;
    }

    public void setAllOrders(List<Order> allOrders) {
        this.allOrders = allOrders;
    }

    public Order getCurrOrder() {
        return currOrder;
    }

    public void setCurrOrder(Order currOrder) {
        this.currOrder = currOrder;
    }

    public OffsetDateTime getDeletedDate() {
        return deletedDate;
    }

    public void setDeletedDate(OffsetDateTime deletedDate) {
        this.deletedDate = deletedDate;
    }

    public String getDeletedBy() {
        return deletedBy;
    }

    public void setDeletedBy(String deletedBy) {
        this.deletedBy = deletedBy;
    }

    public UUID getId() {
        return id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

}