package com.company.deliverytest.entity;

import io.jmix.core.metamodel.datatype.EnumClass;

import org.springframework.lang.Nullable;


public enum StatusOrder implements EnumClass<Integer> {

    PROCESSING(10),
    PREPARING(20),
    IN_DELIVERY(30),
    DELIVERED(40);

    private final Integer id;

    StatusOrder(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return id;
    }

    @Nullable
    public static StatusOrder fromId(Integer id) {
        for (StatusOrder at : StatusOrder.values()) {
            if (at.getId().equals(id)) {
                return at;
            }
        }
        return null;
    }
}