package com.company.jmixcahetest27.listener;

import io.jmix.core.event.EntityChangedEvent;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class EntityCacheClearingEventListener {

    @PersistenceContext
    EntityManager em;

    @TransactionalEventListener(phase = TransactionPhase.BEFORE_COMMIT)
    public void onChangedBeforeCommit(final EntityChangedEvent<?> event) {
        if (event.getType() == EntityChangedEvent.Type.DELETED) {
            em.getEntityManagerFactory().getCache().evict(event.getEntityId().getEntityClass(),event.getEntityId().getValue());
        }
    }
}