package com.company.test.screen.test_entity

import com.company.test.entity.TestEntity
import io.jmix.core.DataManager
import io.jmix.core.LoadContext
import io.jmix.ui.component.Button
import io.jmix.ui.component.DataGrid
import io.jmix.ui.screen.*
import io.jmix.ui.screen.Target
import org.springframework.beans.factory.annotation.Autowired

@UiController("jt_TestEntity.browse")
@UiDescriptor("test-entity-browse.xml")
@LookupComponent("testEntitiesTable")
class TestEntityBrowse : StandardLookup<TestEntity>() {
    @Autowired
    private lateinit var dataManager: DataManager

    @Autowired
    private lateinit var testEntitiesTable: DataGrid<TestEntity>

    @Install(to = "testEntitiesDl", target = Target.DATA_LOADER)
    private fun testEntitiesDlLoadDelegate(loadContext: LoadContext<TestEntity>?): MutableList<TestEntity> {
        // Here you can load entities from an external store
        return createEntities().toMutableList()
    }

    fun createEntities(): List<TestEntity> {
        val entities = (1..500).map {
            val testEntity = dataManager.create(TestEntity::class.java)
            testEntity.name = it.toString()
            testEntity
        }
        return entities
    }

    @Subscribe("test")
    private fun onTestClick(event: Button.ClickEvent) {
        val selected = testEntitiesTable.selected
        selected.size
    }
}